/** @file   soundsamples.h
 * @brief   Contains the indices of the sound samples.
 * @version $Revision: 1.4 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_SOUNDSAMPLES_H
#define H_WWW_SOUNDSAMPLES_H

#include "sound.h"

namespace WeWantWar {
  const int SMP_WEAPON1 = 0;
  const int SMP_ALIEN1_PAIN = 1;
  const int SMP_ALIEN2_DIE = 2;
  const int SMP_ALIEN1_PAIN2 = 3;
  const int SMP_RICCO1 = 4;
  const int SMP_RICCO2 = 5;
  const int SMP_ALIEN1_DIE = 6;
  const int SMP_INTRO = 7;
  const int SMP_ALIEN2_PAIN = 8;
  const int SMP_PLAYER_PAIN = 9;
  const int SMP_DOOR1 = 10;
  const int SMP_WEAPON2 = 11;
  const int SMP_NEWWEAPON = 12;
  const int SMP_BOUNCE = 13;
  const int SMP_GRENADE = 14;
  const int SMP_SLASH = 15;
  const int SMP_HAMMERHIT = 16;
  const int SMP_FIRSTAID = 17;
  const int SMP_ALIEN3_DIE = 18;
  const int SMP_ALIEN3_SHOOT = 19;
  const int SMP_BADASSALIEN_PAIN = 20;
  const int SMP_BADASSALIEN_DIE = 21;
  const int SMP_ALIEN4_DIE = 22;
  const int SMP_WEAPON3 = 23;
  const int SMP_GASLEAK = 24;
  const int SMP_THUNDER = 25;
  const int SMP_WEAPON4 = 26;
  const int SMP_WEAPON5 = 27;
  const int SMP_DOOR2 = 28;
  const int SMP_DOOR3 = 29;
  const int SMP_METALHIT = 30;
  const int SMP_DETONATE = 31;
  const int SMP_CIVILIAN_DIE = 32;
  const int SMP_CARHORN = 33;
  const int SMP_WOMAN_DIE = 34;
  const int SMP_FOUNTAIN = 35;
  const int SMP_CAMPFIRE = 36;
  const int SMP_NIGHTCLUB = 37;
  const int SMP_MENUITEM = 38;
  const int SMP_MENUSELECT = 39;
  const int SMP_AEROPLANE = 40;
  const int SMP_SENTRYSHOOT3 = 41;
  const int SMP_TANKSHOOT = 42;
  const int SMP_TANKMOVE = 43;
  const int SMP_BULLETTIME_BEGIN  = 44;
  const int SMP_BULLETTIME_END = 45;
  const int SMP_HEARTBEAT = 46;
  const int SMP_ELECTRICITY = 47;
  const int SMP_MINE = 48;
  const int SMP_GLASS = 49;
  const int SMP_EXTRALIFE = 50;
  const int SMP_FOOTSTEP = 51;
  const int SMP_FLAMERALIEN_SCREAM = 52;
  const int SMP_BARRELROLL = 53;
  const int SMP_BULLETSHELL = 54;
  const int SMP_WEAPON6 = 55;
  const int SMP_WEAPON7 = 56;
  const int SMP_LIGHTBALLGUN = 57;
  const int SMP_COMBO_TRIPLEKILL = 58;
  const int SMP_COMBO_BUTCHER = 59;
  const int SMP_COMBO_SERIALKILLER = 60;
  const int SMP_COMBO_ALIENMASSACRE = 61;
  const int SMP_WORMSPLASH = 62;
  const int SMP_CLOCK1 = 63;
  const int SMP_CLOCK2 = 64;
};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: soundsamples.h,v $
 * Revision 1.4  2006/06/03 15:51:16  lamminsa
 * Clock samples added.
 *
 * Revision 1.3  2006/04/25 18:03:45  lamminsa
 * Comments removed and new samples added.
 *
 * Revision 1.2  2006/04/03 20:55:51  lamminsa
 * Combo samples added.
 *
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.2  2005-11-23 00:22:22+02  lamminsa
 * <>
 *
 * Revision 1.1  2005-11-13 14:34:29+02  lamminsa
 * RocketLauncher sample added.
 *
 */
 
